<?php


use Elementor\Base_Data_Control;
use Elementor\Modules\DynamicTags\Module as TagsModule;

class Control_Persian_Date_Picker extends Base_Data_Control {

	/**
	 * Get date time control type.
	 *
	 * Retrieve the control type, in this case `date_time`.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Control type.
	 */
	public function get_type() {
		return 'persian_date_picker';
	}

	/**
	 * Get date time control default settings.
	 *
	 * Retrieve the default settings of the date time control. Used to return the
	 * default settings while initializing the date time control.
	 *
	 * @since 1.8.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */
	protected function get_default_settings() {
		return [
			'label_block' => true,
			'picker_options' => [],
			'dynamic' => [
				'categories' => [
					TagsModule::DATETIME_CATEGORY,
				],
			],
		];
	}

	/**
	 * Render date time control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function content_template() {
		$document = \Elementor\Plugin::$instance->documents->get( get_the_ID() );
		$value    = get_option( 'my_custom_elementor_checkbox' );
		if ( $document instanceof \Elementor\Core\DocumentTypes\PageBase ) {
			if ( strlen($value) < 1 ) {
				wp_enqueue_style( 'pDate-style', plugins_url( 'elementor-pro' ) . '/megatheme/includes/assets/css/persian-datepicker.min.css', [], null );

			wp_enqueue_script( 'pDate',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-date.min.js', ['jquery'], null, true );
			wp_enqueue_script( 'pDatepicker',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker.min.js', ['pDate'], null, true );
			wp_enqueue_script( 'pDatepickerLoader',plugins_url('elementor-pro') .'/megatheme/includes/assets/js/persian-datepicker-loader.js', ['pDatepicker'], null, true );
            ?>

            <div class="elementor-control-field">
                <label for="<?php $this->print_control_uid(); ?>" class="elementor-control-title">{{{ data.label }}}</label>
                <div class="elementor-control-input-wrapper elementor-control-dynamic-switcher-wrapper">
                    <input onclick="(function(value){value=value.replace('_fake','');jQuery('#'+value+'_fake').pDatepicker({
            format: 'YYYY-MM-DD HH:mm',
            autoClose: true,
            timePicker: {
                enabled: true
            },
            formatter: function (unix) {
                let date = new Date(unix);

                let year = date.getFullYear();
                let month = ('0' + (date.getMonth() + 1)).slice(-2);
                let day = ('0' + date.getDate()).slice(-2);
                let hours = ('0' + date.getHours()).slice(-2);
                let minutes = ('0' + date.getMinutes()).slice(-2);

                let formattedDate = year + '-' + month + '-' + day + ' ' + hours + ':' + minutes;

                let element = document.getElementById(value);

                if (element) {
                    element.value = formattedDate;
                    // Create a new 'input' event
                    let event = new Event('input', {
                        bubbles: true,
                        cancelable: true,
                    });

                    // Dispatch the event
                    element.dispatchEvent(event);
                } else {
                    console.log('Element not found!');
                }

                return formattedDate;
            }
        })})(this.id)" id="<?php $this->print_control_uid(); ?>_fake" placeholder="" class="elementor-date-time-picker elementor-control-tag-area" type="text" data-setting="{{ data.name }}" readonly="readonly">

                    <input style="position:absolute;opacity: 0;z-index: -1" id="<?php $this->print_control_uid(); ?>" placeholder="{{ view.getControlPlaceholder() }}" class="elementor-date-time-picker elementor-control-tag-area" type="text" data-setting="{{ data.name }}">
                </div>
            </div>
            <# if ( data.description ) { #>
            <div class="elementor-control-field-description">{{{ data.description }}}</div>
            <# } #>
                <?php
		} else {
			?>

            <div class="elementor-control-field">
                <label for="<?php $this->print_control_uid(); ?>" class="elementor-control-title">{{{ data.label }}}</label>
                <div class="elementor-control-input-wrapper elementor-control-dynamic-switcher-wrapper">
                    <input id="<?php $this->print_control_uid(); ?>" placeholder="{{ view.getControlPlaceholder() }}" class="elementor-date-time-picker elementor-control-tag-area" type="text" data-setting="{{ data.name }}">
                </div>
            </div>
            <# if ( data.description ) { #>
            <div class="elementor-control-field-description">{{{ data.description }}}</div>
            <# } #>
                <?php
		}
		}
		?>

		<?php
	}
}



