<?php
/**
 * Integration Step
 */

namespace ElementPack\SetupWizard;

if (!defined('ABSPATH')) {
    exit;
}

$ep_plugins = array(
    array(
    'name'        => esc_html__('Prime Slider', 'bdthemes-element-pack'),
    'slug'        => 'bdthemes-prime-slider-lite/bdthemes-prime-slider.php',
    'description' => esc_html__('Create eye-catching sliders for your website quickly and easily.', 'bdthemes-element-pack'),
    'recommended' => true,
),
    array(
        'name'        => esc_html__('ZoloBlocks', 'bdthemes-element-pack'),
        'slug'        => 'zoloblocks/zoloblocks.php',
        'description' => esc_html__('Build amazing WordPress pages with helpful and flexible Gutenberg blocks.','bdthemes-element-pack'),
        'recommended' => false,
    ),
    array(
        'name'        => esc_html__('Ultimate Post Kit','bdthemes-element-pack'),
        'slug'        => 'ultimate-post-kit/ultimate-post-kit.php',
        'description' => esc_html__('Design beautiful post layouts with simple, ready-made blocks.','bdthemes-element-pack'),
        'recommended' => true,
    ),
    array(
        'name'        => esc_html__('Ultimate Store Kit','bdthemes-element-pack'),
        'slug'        => 'ultimate-store-kit/ultimate-store-kit.php',
        'description' => esc_html__('Improve your online store with tools to display products better.','bdthemes-element-pack'),
        'recommended' => true,
    ),
    array(
        'name'        => esc_html__('Pixel Gallery','bdthemes-element-pack'),
        'slug'        => 'pixel-gallery/pixel-gallery.php',
        'description' => esc_html__('Show off your photos in a stylish, responsive gallery.','bdthemes-element-pack'),
        'recommended' => false,
    ),
    array(
        'name'        => esc_html__('Live Copy Paste','bdthemes-element-pack'),
        'slug'        => 'live-copy-paste/live-copy-paste.php',
        'description' => esc_html__('Copy and paste website elements between WordPress sites instantly.','bdthemes-element-pack'),
        'recommended' => false,
    ),
    array(
        'name'        => esc_html__('Instant Image Generator','bdthemes-element-pack'),
        'slug'        => 'ai-image/ai-image.php',
        'description' => esc_html__('Generate unique images using AI directly in WordPress.','bdthemes-element-pack'),
        'recommended' => false,
    ),
    array(
        'name'        => esc_html__('AR Viewer','bdthemes-element-pack'),
        'slug'        => 'ar-viewer/ar-viewer.php',
        'description' => esc_html__('Let users view your products in 3D with augmented reality.','bdthemes-element-pack'),
        'recommended' => false,
    ),
    array(
        'name'        => esc_html__('Spin Wheel','bdthemes-element-pack'),
        'slug'        => 'spin-wheel/spin-wheel.php',
        'description' => esc_html__('Engage your visitors with a fun and interactive spin wheel.','bdthemes-element-pack'),
        'recommended' => false,
    ),
);
?>

<div class="bdt-wizard-step bdt-setup-wizard-integration" data-step="integration">
    <h2><?php esc_html_e('Add More Firepower', 'bdthemes-element-pack'); ?></h2>
    <p><?php esc_html_e('You can onboard additional powerful plugins to extend your web design capabilities.', 'bdthemes-element-pack'); ?></p>

    <div class="progress-bar-container">
        <div id="plugin-install-progress" class="progress-bar"></div>
    </div>

    <form method="POST" id="ep-install-plugins">
        <div class="bdt-plugin-list">
            <?php
            foreach ($ep_plugins as $plugin) :
                $is_active = is_plugin_active($plugin['slug']);
                $is_recommended = $plugin['recommended'] && !$is_active;
            ?>
                <label class="plugin-item" data-slug="<?php echo esc_attr($plugin['slug']); ?>">
                    <span class="bdt-flex bdt-flex-middle bdt-flex-between bdt-margin-small-bottom">
						<span class="bdt-plugin-name">
							<?php echo wp_kses_post($plugin['name']); ?>
						</span>
                        <div class="bdt-plugin-badge-switch-wrap">

                        <?php if ($is_recommended) : ?>
                            <span class="recommended-badge"><?php esc_html_e('Recommended', 'bdthemes-element-pack'); ?></span>
                        <?php endif; ?>
                        
                        <?php if ($is_active) : ?>
                            <span class="active-badge"><?php esc_html_e('ACTIVE', 'bdthemes-element-pack'); ?></span>
                        <?php endif; ?>
                         <?php
                         if (!$is_active) : ?>
                             <label class="switch">
                                 <input type="checkbox" class="plugin-slider-checkbox" <?php echo wp_kses_post($plugin['recommended']) ? 'checked' : ''; ?>
                                        name="plugins[]<?php echo isset($plugin['slug']) ? wp_kses_post($plugin['slug']) : ''; ?>">
                                 <span class="slider round"></span>
                             </label>
                         <?php
                         endif;
                         ?>
                        </div>
					</span>
                    <span class="plugin-text">
						<?php echo wp_kses_post($plugin['description']); ?>
					</span>
                </label>
            <?php
            endforeach; ?>
        </div>
        
        <div class="wizard-navigation bdt-margin-top">
            <button class="bdt-button bdt-button-primary d-none" type="submit" id="ep-install-plugins-btn">
                <?php esc_html_e('Install and Continue', 'bdthemes-element-pack'); ?>
            </button>
            <div class="bdt-close-button bdt-margin-left bdt-wizard-next" data-step="finish"><?php esc_html_e('Skip', 'bdthemes-element-pack'); ?></div>
        </div>
    </form>

    <div class="bdt-wizard-navigation">
        <button class="bdt-button bdt-button-secondary bdt-wizard-prev" data-step="features">
            <span><i class="dashicons dashicons-arrow-left-alt"></i></span>
            <?php esc_html_e('Previous Step', 'bdthemes-element-pack'); ?>
        </button>
    </div>
</div>
