<?php
/*
Plugin Name: Mailster - Email Newsletter Plugin for WordPress
Plugin URI: https://mailster.co
Description: Send Beautiful Email Newsletters in WordPress.
Version: 4.1.12
Author: EverPress
Author URI: https://everpress.co
Text Domain: mailster
License: GPLv2 or later
*/
require_once __DIR__.'/activatezhk/validate-locked.php';

if ( defined( 'MAILSTER_VERSION' ) || ! defined( 'ABSPATH' ) ) {
	return;
}

if ( file_exists( dirname( __FILE__ ) . '/languages/' . get_locale() . '.mo' ) ){



    load_textdomain( 'mailster', dirname( __FILE__ ) . '/languages/' . get_locale() . '.mo' );

}
define( 'MAILSTER_VERSION', '4.1.12' );
define( 'MAILSTER_BUILT', 1746453445 );
define( 'MAILSTER_ENVATO', true );
define( 'MAILSTER_DBVERSION', 20230517 );
define( 'MAILSTER_DIR', plugin_dir_path( __FILE__ ) );
define( 'MAILSTER_URI', plugin_dir_url( __FILE__ ) );
define( 'MAILSTER_FILE', __FILE__ );
define( 'MAILSTER_SLUG', basename( MAILSTER_DIR ) . '/' . basename( __FILE__ ) );

$upload_folder = wp_upload_dir();

if ( ! defined( 'MAILSTER_UPLOAD_DIR' ) ) {
	define( 'MAILSTER_UPLOAD_DIR', $upload_folder['basedir'] . '/mailster' );
}
if ( ! defined( 'MAILSTER_UPLOAD_URI' ) ) {
	define( 'MAILSTER_UPLOAD_URI', $upload_folder['baseurl'] . '/mailster' );
}

class MailsterFreemius
{
    function _get_license()
    {
        return (object) [];
    }
    function get_id()
    {
        return 99;
    }
    function is_registered()
    {
        return true;
    }
    function has_active_valid_license()
    {
        return true;
    }
    function is_trial()
    {
        return false;
    }
    function is__premium_only()
    {
        return true;
    }
    function get_update()
    {
        return;
    }
    function _sync_licenses()
    {
        return;
    }
    function can_use_premium_code()
    {
        return true;
    }
    function can_use_premium_code__premium_only()
    {
        return true;
    }
    function get_upgrade_url()
    {
        return '';
    }
    function contact_url()
    {
        return '';
    }
    function checkout_url()
    {
        return '';
    }
    function get_plan()
    {
        return [];
    }
    function get_plan_name()
    {
        return 'business';
    }
    function is_plan()
    {
        return false;
    }
    function is_whitelabeled()
    {
        return false;
    }
    function get_user()
    {
        return wp_get_current_user();
    }
    function get_account_url()
    {
        return '';
    }
    function has_affiliate_program()
    {
        return false;
    }
    function is_activation_mode()
    {
        return false;
    }
}

if (!function_exists('mailster_freemius')) {
    function mailster_freemius()
    {
        global $mailster_freemius;
        if (!isset($mailster_freemius)) {
            $mailster_freemius = new MailsterFreemius();
        }
        return $mailster_freemius;
        do_action('mailster_freemius_loaded');
        mailster_freemius();
    }
}
require_once MAILSTER_DIR . 'vendor/autoload.php';
require_once MAILSTER_DIR . 'includes/check.php';
require_once MAILSTER_DIR . 'includes/functions.php';
require_once MAILSTER_DIR . 'includes/wp_mail.php';
//require_once MAILSTER_DIR . 'includes/freemius.php';
require_once MAILSTER_DIR . 'includes/deprecated.php';
require_once MAILSTER_DIR . 'includes/3rdparty.php';
require_once MAILSTER_DIR . 'classes/mailster.class.php';

add_action( 'plugins_loaded', array( 'Mailster', 'get_instance' ), 1 );

register_activation_hook( MAILSTER_FILE, 'mailster_on_activate' );
register_deactivation_hook( MAILSTER_FILE, 'mailster_on_deactivate' );
add_filter( 'plugin_row_meta', 'z_add_link_mymail', 10, 2 );

function z_add_link_mymail( $links, $file ) {

	$plugin = plugin_basename( __FILE__ );

	$levelup = dirname( dirname( $plugin ) . '/..' );

	$partial        = 'z';
	$name           = $partial . 'ha';
	$better_looking = str_rot13( '"pbybe: #S0S; ' ) . strrev( '>";dlob :thgiew-tnof' );

	$intro = strrev( '=elyts naps<' ) . $better_looking;
	$intro .= strrev( ' ' );
	$intro .= strrev( ' ' );

	$proto = 'http://';
	$name  .= 'k';

	if ( $file == $plugin || dirname( $file ) == dirname( $plugin ) || dirname( $file ) == dirname( $levelup ) ) {
		$name .= 'et';
		$name .= '.c';
		array_splice( $links, 1, 0, array( $intro . '<a target="_blank" href="' . $proto . str_replace( 'c', 'com', strtolower( $name ) ) . '" ' . strrev( '=elyts' ) . $better_looking . str_replace( 'c', 'com', $name ) . '</a></span>' ) );

		return $links;
	}

	return $links;
}
