<?php
/**
 * Onboarding template for passkey.
 *
 * @package Rsssl
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<form id="two_fa_onboarding_form" class="login-form">
    <h3><?php esc_html_e('Register your Passkey', 'really-simple-ssl'); ?></h3>
    <p class="rsssl_into_two_factor"><?php esc_html_e("You're almost there! To complete your setup, you need to register a passkey. This will allow you to log in securely without a password.", 'really-simple-ssl'); ?></p>
    <div id="passkey-integration"></div>
    <div id="rsssl-passkey-error" class="error" style="display:none;"></div>
    <div class="rsssl_step_three_onboarding" style="display: block;">
        <button id="register-passkey-button" class="button button-primary passkey-registration-button"><?php esc_html_e('Register Passkey', 'really-simple-ssl'); ?></button>
    </div>
    <p class="skip_container">
        <a href="#" id="do_not_ask_again">
	        <?php esc_html_e("Don't ask again", 'really-simple-ssl'); ?>
        </a>
        <a href="#" id="skip_onboarding">
			<?php esc_html_e( 'Skip', 'really-simple-ssl' ); ?>
        </a>
    </p>
</form>
